#ifndef DB_UTIL_H
#define DB_UTIL_H

#include <dpp/dpp.h>
#include <iostream>
#include <string>
#include <vector>

#include "../entities/queue-item.h"
#include "../entities/queue.h"
#include "../entities/search.h"
#include "../entities/shortcut.h"
#include <sqlite3.h>

class DbUtil
{

public:
    static QueueEntity getQueue(dpp::snowflake guildId);
    static std::vector<QueueItemEntity> getQueueItems(int queueId, int offset = -1);
    static int getCountQueueItems(int queueId);
    static void saveQueueItems(int queueId, std::vector<QueueItemEntity> queueItems);
    static bool removeQueueItem(QueueItemEntity queueItem);
    static QueueItemEntity getCurrentQueueItem(int currentItemId);
    static void setCurrentQueueItem(int queueId, int queueItemId);
    static SearchEntity getSearch(std::string searchTerm);
    static QueueItemEntity getQueueItemByDisplayName(std::string searchTerm);
    static void saveSearch(SearchEntity search);

    static bool saveShortcut(ShortcutEntity shortcut);
    static std::vector<ShortcutEntity> getShortcuts(dpp::snowflake guildId);
    static ShortcutEntity getShortcutByCommand(std::string command, dpp::snowflake guildId);
    static bool removeShortcutByCommandOrQuery(std::string commandOrQuery, dpp::snowflake guildId);

    static sqlite3 *connectDb();
    static void closeDb(sqlite3 *connection);
    static void closeDb(sqlite3 *connection, sqlite3_stmt *statement);

private:
    static void createShortcutTable(sqlite3 *connection);
};

#endif
