#include <fstream>
#include <iostream>
#include <filesystem>
namespace fs = std::filesystem;

#include "config.h"

void ConfigUtil::initConfig()
{
    const std::string home = getenv("HOME");
    std::string config_path;

    // Check some standard directories for the config file
    if (fs::is_regular_file(fs::status(home+"/.local/share/musigloutr/config.json")))
    {
        config_path = home+"/.local/share/musigloutr/config.json";
    }
    else if (fs::is_regular_file(fs::status(home+"/.config/musigloutr/config.json")))
    {
        config_path = home+"/.config/musigloutr/config.json";
    }
    else if (fs::is_regular_file(fs::status(home+"/.musigloutr/config.json")))
    {
        config_path = home+"/.musigloutr/config.json";
    }
    else if (fs::is_regular_file(fs::status(home+"/musigloutr++.json")))
    {
        config_path = home+"/musigloutr++.json";
    }
    else
    {
        // Create sample config file
        fs::create_directory(home+"/.local/");
        fs::create_directory(home+"/.local/share/");
        fs::create_directory(home+"/.local/share/musigloutr/");
        std::ofstream config_file (home+"/.local/share/musigloutr/config.json");
        config_file << "{}";
        config_file.close();
        std::cerr << "Could not find any config file. I've created an empty config file for your convenience in "+home+"/.local/share/musigloutr/config.json" << std::endl;
        std::exit(8);
    }
    initConfig(config_path);
}

void ConfigUtil::initConfig(std::string config_path)
{
    std::clog << "Config path is " << config_path << std::endl;
    std::ifstream inputFileStream(config_path);
    if (!inputFileStream.good())
    {
        std::cerr << "Could not read config file" << std::endl;
        std::exit(8);
    }
    config = nlohmann::json::parse(inputFileStream);
}

std::string ConfigUtil::get(std::string option, bool required)
{
    if (config == NULL)
    {
        std::cerr << "Configuration was accessed before initialisation" << std::endl;
        exit(8);
    }

    try
    {
        return config.at(option);
    }
    catch (nlohmann::json::exception e)
    {
        std::stringstream errorMessage;
        errorMessage << "Config option " << option << " not found. Please check the configuration file";

        if (required)
        {
            std::cerr << errorMessage.str() << std::endl;
            std::exit(8);
        }
    }

    return "";
}