#include "queue-item.h"

QueueItemEntity::QueueItemEntity(sqlite3_stmt *statement) : AbstractEntity(statement)
{
    queueId = sqlite3_column_int(statement, 1);
    source = std::string(reinterpret_cast<const char *>(sqlite3_column_text(statement, 2)));
    displayName = std::string(reinterpret_cast<const char *>(sqlite3_column_text(statement, 3)));
    position = sqlite3_column_int(statement, 4);
    duration = sqlite3_column_int(statement, 5);
    rowNumber = sqlite3_column_int(statement, 6);
}

QueueItemEntity::QueueItemEntity(int queueId, std::string source, std::string displayName, int position, int duration) : queueId(queueId), source(source), displayName(displayName), position(position), rowNumber(position), duration(duration)
{
}

std::string QueueItemEntity::getDisplayName() const
{
    return "[" + displayName + "](" + source + ")";
}
