#include "../entities/queue.h"
#include "../entities/queue-item.h"
#include "../utils/db.h"
#include "queue-search-jump.h"
#include "../utils/voice-connection.h"

QueueSearchJumpCommand::QueueSearchJumpCommand(dpp::cluster &bot, PlayCommand &playCommand, JumpCommand &jumpCommand) : AbstractCommand(bot), playCommand(playCommand), jumpCommand(jumpCommand)
{
}

bool QueueSearchJumpCommand::userMustBeInBotsChannel()
{
    return true;
}

std::vector<std::string> QueueSearchJumpCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-queuesearchjump (.*)$");
    regex.push_back("^-qsj (.*)$");
    return regex;
}

std::string QueueSearchJumpCommand::getHelp()
{
    return "**-queuesearchjump [search term], -qsj [search term]:** Searches the queue history for the given title and plays it immediately. The search is not case sensitive. If multiple entries match, the last added entry is chosen.";
}

void QueueSearchJumpCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    //Get voice connection
    dpp::voiceconn *v = event.from->get_voice(event.msg.guild_id);
    if (!v || !v->voiceclient->is_ready())
    {
        //Join voice channel
        if (!VoiceConnection::connectToVoiceChannel(event))
        {
            error(event, "You don't seem to be in a voice channel! :(");
            return;
        }
        VoiceConnection::connectToVoiceBlocking(bot, event);
    }

    v = event.from->get_voice(event.msg.guild_id);
    if (v->voiceclient->is_playing())
    {
        //Stop encoding of audio of currently playing song
        playCommand.guildIdAbortedEncodes[event.msg.guild_id] = true;
    }


    QueueItemEntity queueItem = DbUtil::getQueueItemByDisplayName(match1);

    if(queueItem.displayName == "") {
        error(event, "No match found in queue");
        return;
    }

    std::cout << "Got entity " + queueItem.displayName + " with url " + queueItem.source << std::endl;

    //Jump to queue item with specified position
    jumpCommand.jumpToQueueItem(event, queueItem);
}