#include "../entities/queue.h"
#include "../entities/queue-item.h"
#include "../utils/db.h"
#include "playnext.h"

PlayNextCommand::PlayNextCommand(dpp::cluster &bot, PlayCommand &playCommand) : AbstractCommand(bot), playCommand(playCommand)
{
}

bool PlayNextCommand::userMustBeInBotsChannel()
{
    return true;
}

std::vector<std::string> PlayNextCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-playnext (.*)$");
    regex.push_back("^-pn (.*)$");
    return regex;
}

std::string PlayNextCommand::getHelp()
{
    return "**-playnext [search term|url], -pn [search term|url]:** The given url/song will be played as the next song";
}

void PlayNextCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    std::string uri = match1;

    QueueEntity queue = DbUtil::getQueue(event.msg.guild_id);
    std::vector<QueueItemEntity> queueItems = DbUtil::getQueueItems(queue.id);

    //Get index of current queue item (recalculate index because it is not always sequential/updated in the database)
    int position = 1;
    for (int i = 0; i < queueItems.size(); i++)
    {
        if (queueItems[i].id == queue.currentItemId)
        {
            position = i;
        }
    }

    playCommand.addQueueItem(event, uri, queue, position + 1);
}