#ifndef PLAY_COMMAND_H
#define PLAY_COMMAND_H

#include <iostream>
#include <map>
#include <dpp/dpp.h>

#include "../entities/queue.h"
#include "../entities/queue-item.h"
#include "abstract.h"

class PlayCommand : public AbstractCommand
{

public:
    using AbstractCommand::AbstractCommand;
    std::map<dpp::snowflake, int> guildIdAbortedEncodes;
    virtual std::vector<std::string> getRegex();
    virtual std::string getHelp();
    virtual void execute(dpp::message_create_t event, std::string match1, std::string match2);
    int play(dpp::discord_voice_client *v, dpp::message_create_t event, QueueItemEntity queueItem);
    int playNext(dpp::discord_voice_client *v, dpp::message_create_t event, QueueItemEntity queueItem);
    QueueItemEntity addQueueItem(dpp::message_create_t event, std::string uri, QueueEntity queue, int position = -1, bool sendResponse = true);
    virtual bool userMustBeInBotsChannel();

private:
    bool autoLeaveThreadStarted = false;
    std::jthread autoLeaveThread;

    std::string executeScript(std::string command);
    int isGuildIdEncodeAborted(dpp::snowflake guildId);
    void startAutoLeaveThread(dpp::discord_voice_client *voiceclient, dpp::message_create_t event);
};

#endif