#include "pause.h"

std::vector<std::string> PauseCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-pause$");
    return regex;
}

bool PauseCommand::userMustBeInBotsChannel()
{
    return true;
}

std::string PauseCommand::getHelp()
{
    return "**-p, -pause:** Pauses the currently playing song";
}

void PauseCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    //Get voice connection
    dpp::voiceconn *v = event.from->get_voice(event.msg.guild_id);

    if (!v || !v->voiceclient->is_ready())
    {
        error(event, "Currently not in voice channel");
    }
    else
    {
        v->voiceclient->pause_audio(true);
        success(event, "Playback paused");
    }
}