#ifndef NEXT_COMMAND_H
#define NEXT_COMMAND_H

#include "abstract.h"
#include "play.h"

class NextCommand : public AbstractCommand
{

private:
    PlayCommand &playCommand;
    std::map<dpp::snowflake, std::shared_future<void>> &playCommandFutures;

public:
    using AbstractCommand::AbstractCommand;
    NextCommand(dpp::cluster &bot, PlayCommand &playCommand, std::map<dpp::snowflake, std::shared_future<void>> &playCommandFutures);
    virtual bool userMustBeInBotsChannel();
    virtual std::vector<std::string> getRegex();
    virtual std::string getHelp();
    virtual void execute(dpp::message_create_t event, std::string match1, std::string match2);
};

#endif