#include "kill.h"

KillCommand::KillCommand(dpp::cluster &bot, PlayCommand &playCommand) : AbstractCommand(bot), playCommand(playCommand)
{
}

std::vector<std::string> KillCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-kill$");
    regex.push_back("^-kys$");
    regex.push_back("^-k$");
    return regex;
}

std::string KillCommand::getHelp()
{
    return "**-kill, -kys, -k:** Bot will kill itself";
}

void KillCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    //Get voice connection
    dpp::voiceconn *v = event.from->get_voice(event.msg.guild_id);

    if (v && v->is_ready())
    {

        if (v->voiceclient && v->voiceclient->is_playing())
        {
            //Send signal to playCommand to flush
            playCommand.guildIdAbortedEncodes[event.msg.guild_id] = 2;
        }
        else
        {
            //Not playing --> directly leave voice channel
            event.from->disconnect_voice(event.msg.guild_id);
        }
    }
    success(event, "Goodbye cruel world", "", "https://pbs.twimg.com/media/GdFiy2OXIAANAeQ?format=jpg");

    std::this_thread::sleep_for(std::chrono::milliseconds(1500));
    exit(99);
}
