#ifndef JUMP_COMMAND_H
#define JUMP_COMMAND_H

#include "play.h"
#include "abstract.h"

class JumpCommand : public AbstractCommand
{

private:
    PlayCommand &playCommand;
    std::map<dpp::snowflake, std::shared_future<void>> &playCommandFutures;

public:
    using AbstractCommand::AbstractCommand;
    JumpCommand(dpp::cluster &bot, PlayCommand &playCommand, std::map<dpp::snowflake, std::shared_future<void>> &playCommandFutures);
    virtual std::vector<std::string> getRegex();
    virtual std::string getHelp();
    virtual void execute(dpp::message_create_t event, std::string match1, std::string match2);
    virtual void jumpToQueueItem(dpp::message_create_t event, QueueItemEntity &queueItemEntity);
};

#endif