#include "join.h"

std::vector<std::string> JoinCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-join$");
    regex.push_back("^-j$");
    return regex;
}

std::string JoinCommand::getHelp()
{
    return "**-join, -j:** Joins the voice channel the user is currently in";
}

void JoinCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{
    dpp::guild *g = dpp::find_guild(event.msg.guild_id);

    if (!g->connect_member_voice(event.msg.author.id, false, true))
    {
        error(event, "You don't seem to be in a voice channel! :(");
    }
    else
    {
        //Get voice connection in order to get voice channel name
        dpp::voiceconn *v = event.from->get_voice(event.msg.guild_id);
        success(event, "Joined voice channel \"" + dpp::find_channel(v->channel_id)->name + "\"");
    }
}