#include "help.h"
#include "../entities/shortcut.h"
#include "../utils/db.h"
#include "../utils/general.h"
#include <map>

HelpCommand::HelpCommand(dpp::cluster &bot, std::vector<std::shared_ptr<AbstractCommand>> &commands) : AbstractCommand(bot), commands(commands)
{
}

std::vector<std::string> HelpCommand::getRegex()
{
    std::vector<std::string> regex;
    regex.push_back("^-help$");
    regex.push_back("^-h$");
    return regex;
}

std::string HelpCommand::getHelp()
{
    return "**-help, -h:** Show this list of commands";
}

void HelpCommand::execute(dpp::message_create_t event, std::string match1, std::string match2)
{

    std::string description = "";
    for (int i = 0; i < commands.size(); i++)
    {
        description += commands[i]->getHelp() + "\n\n";
    }

    //Shortcut commands
    std::vector<ShortcutEntity> shortcuts = DbUtil::getShortcuts(event.msg.guild_id);
    if (!shortcuts.empty())
    {
        description += "\n**Shortcuts**\n\n";

        //Group shortcuts
        std::map<std::string, std::string> groupedShortcuts = {};
        for (ShortcutEntity const &shortcut : shortcuts)
        {
			if(!groupedShortcuts.contains(shortcut.query)) {
				groupedShortcuts[shortcut.query] = "";
			}

			if(!groupedShortcuts[shortcut.query].empty()) {
				groupedShortcuts[shortcut.query] += ", ";
			}

            groupedShortcuts[shortcut.query] += "-" + shortcut.command;
        }

        //Add shortcuts to description
        for(const auto &[key, value] : groupedShortcuts) {
			description += "**" + value + "**: ";

	        if (GeneralUtil::isUrl(key)) {
				description += " [link](" + key + ")";
	        } else {
	            description += " " + key;
	        }

			description += "\n\n";
        }
    }

    success(event, "List of available commands", description);
}
