#ifndef ABSTRACT_COMMAND_H
#define ABSTRACT_COMMAND_H

#include <string>
#include <vector>
#include <regex>
#include <dpp/dpp.h>

class AbstractCommand
{

public:
    dpp::cluster &bot;

    AbstractCommand(dpp::cluster &bot);

    virtual std::vector<std::string> getRegex() = 0;

    virtual std::string getHelp() = 0;

    virtual void execute(dpp::message_create_t event, std::string match1, std::string match2) = 0;

    virtual bool userMustBeInBotsChannel();

protected:
    void success(dpp::message_create_t event, std::string title, std::string description = std::string(), std::string mediaUri = std::string());

    void error(dpp::message_create_t event, std::string title, std::string description = std::string(), std::string mediaUri = std::string());

    dpp::embed createEmbed(uint32_t color, std::string title, std::string description = std::string(), std::string mediaUri = std::string());

private:
    void sendEmbed(uint32_t color, dpp::message_create_t event, std::string title, std::string description = std::string(), std::string mediaUri = std::string());
};
#endif